'
'CONWAYs Spiel des Lebens    /  ScreenSaver
'===================

' Bedeutung und Regeln : https://de.wikipedia.org/wiki/Conways_Spiel_des_Lebens
' Programmer :   Klaus Brock    klausbrock@hotmail.de       02/2017
' Compile    :   Windows-GUI (FbEdit)
'
' In dieser Version wird mit Zufallskoordinaten jeweil ein sog. "Pentomino" o.a. nach jeweil n Generationen ins 
' Spielfeld angesetzt. Das Spielfeld besteht aus Einzelpixeln über die gesamte phys. Bildschirmgröße. 

Dim Shared As Short i,j,ib,ih,iz,il,k,l,lb,lh,m,n,ix,jx,RegelTyp,fanz,istop,lebend,LivNbrs,breit,hoch,_
                    liox,reux,lioy,reuy,Vzmillsek,zufx,zufy,balkenb,balkenh,balkenb2,balkenh2
Dim Shared As Integer igen,lincolor,circolor,totcolor,lebcolor,backcolor,fndx,MousePosX,MousePosY,MouseKeyState,_
                    scrb,scrh,scrct,xstart,ystart,lage,anfpos,MousePosXneu,MousePosYneu   
  totcolor  = 0
  lebcolor  = 4  ' fuer Initialbelegung, danach zyklisch
  backcolor = 0  ' initialer Spielfeldgatter Hintergrund 
Dim Shared As Integer farbe (1 To 14)  'Farben fuer fndx
  Farbe(1)  =  4              
  Farbe(2)  =  1          
  Farbe(3)  =  2             
  Farbe(4)  =  3             
  Farbe(5)  =  5              
  Farbe(6)  =  6             
  Farbe(7)  =  12 '8=grau (hebt sich nicht genug vom schwarzen Hintergrund ab)       
  Farbe(8)  =  9               
  Farbe(9)  =  10               
  Farbe(10) =  11               
  Farbe(11) =  12               
  Farbe(12) =  13               
  Farbe(13) =  15
  Farbe(14) =  7   
  
Dim shared As BOOLEAN numW    ()  
Dim shared As BOOLEAN numFolg () 
	              
Declare Sub StartWerteSetzen()
Declare Sub SpielfeldGrundstellung()
Declare Sub MainLoop()

Declare Sub CountLivingNeigbors()

' ... die Conway-"Welten" :
Declare Sub KlassischConway() ' in dieser Version nur Conway klassisch !
' ---

Declare Sub AnfangsBelegung()
Declare Sub DropPentomino()
Declare Sub ZellGeburt()
Declare Sub ZellPos()
Declare Sub ZellTod()
Declare Sub StopKey()
Declare Sub Ausgestorben()
Declare Sub ShowArray()

'------------------- Hauptprogramm ----------------------------------------------------------

Cls

Do
	
  Randomize(Timer)
  	
  StartWerteSetzen
	
  'die gewuenschten Dimensionen (lh*lb) der internen Arbeits-Arrays sind jetzt bekannt :
  'numW = aktuelles Feld   /  numFolg = Vormerkungen fuer Folgegeneration
  ReDim  As BOOLEAN numW    (1 To lh, 1 To lb)  
  ReDim  As BOOLEAN numFolg (1 To lh, 1 To lb) 
	
  SpielfeldGrundstellung
  MainLoop
  
Loop


'-------------------  es folgen   Level   1   Sub's ----------------------------------------------------------


Sub StartWerteSetzen
	
  'Print ""	
  'Print "                               "&Chr(178)&Chr(178)	
  'Print "   CONWAY's Spiel des Lebens     "&Chr(178)&Chr(178)
  'Print "   ------------------------- "&Chr(178)&Chr(178)&Chr(178)&Chr(178)&Chr(178)&Chr(178)
  'Print "    self-supplying Version "	
  'Print ""
  'Print "Bedeutung und Regeln : https://de.wikipedia.org/wiki/Conways_Spiel_des_Lebens"
  'Print "Programmer           : Klaus Brock    klausbrock@hotmail.de       02/2017"
  'Print ""	
	
  'phys. Bildschirmaufloesung :	
  SCREENINFO scrb,scrh,scrct
  
  'Setzen physische Fensterbreite u. -hoehe und Zellengroesse (alles als Pixelanzahlen)
  ib  = scrb
  ih  = scrh
  Randomize(Timer)
'  iz  = Int(Rnd*10) +1  'Zellengröße 1 bis 9
  iz  = Int(Rnd*5) +1  'Zellengröße 1 bis 4
    
  'Ermitteln logische Fenstergroesse  (Anzahl Zellen senkrecht und waagerecht)
  'Anpassen der phys. Fenstergroesse an groesstmoegl. ganzahlige Zellenanzahl 
  '...man muss sich also keine Sorgen machen bei der Angabe der phys. Fenstergroesse !
  'Print "Auf ganzzahlige Zellenanzahl angepasste Spielfeldgroesse (Pixel) :"
  ib = ib - ib Mod iz 'math. Remainder
  'Print "  Grafik-Fensterbreite in Pixeln angepasst = "; ib
  ih = ih - ih Mod iz 'math. Remainder 
  'Print "  Grafik-Fensterhoehe  in Pixeln angepasst = "; ih 
  
  'das  ergibt dann eine logische Spielgattergroesse von  lb x lh Zellen,
  ' stellt sicher, dass immer eine ganzzahlige Anzahl Felder im Spieleraster ist :
  'Print "daraus resultierende Spielfeldgroesse (Zellen) :"
  lb = ib \ iz 'math. Floor  
  'Print "  log. Spielfeldbreite in Zellen = Spalten = "; lb 
  lh = ih \ iz 'math. Floor  
  'Print "  log. Spielfeldhoehe  in Zellen = Zeilen  = "; lh 
       
  ' Hier Verzoegerung nach jeder Generation :
  'Print "Verzoegerung nach jeder Generation (zur besseren Sichtbarkeit):"
  'Print "  keine Verzoegerung                             :  0"
  'Print "  Standard-Verzoegerung (abhaeng. von Zellanzahl :  1"
  'Print "  Angabe der Verzoegerung in Millisek.           : nnn"
  'Input "Bitte die Verzoegerung waehlen  : "; Vzmillsek
  Vzmillsek = ((1921-lb) * (1001-lh)) / 30000 
  If iz = 1 Then
  	 Vzmillsek = 0
  EndIf
  'Print "Stanard-Verzoegerung in Millisek.: ";Vzmillsek
      
  'input "Bitte die Farbanzahl eingeben 1 - 13 ( Default 1 ) : "; fanz 
  Randomize(Timer)
'  fanz = Int(Rnd*15) 
  fanz = 3 + Int(Rnd*10) 
  If fanz= 0 Then
     fanz= 14
  ElseIf fanz>14 Then
    fanz=14
  Else  
  EndIf 
  
  ' ... to do :
  'Print "...fertig ? - STOP der Grafikanzeige mit S-Taste, wird danach fortgesetzt"  
  'Print "            - im STOP-Zustand die C-Taste druecken --> Abbruch"
  
End Sub


Sub SpielfeldGrundstellung
  
  'Zeichnen des Spielegatters / hellgraue Linien  gemaess lh und lb + 1 Pixel fuer die Gitterlinie selbst
  ScreenRes ib,ih,8,,&h08    ' Bildschirmmodus breit x hoch bei 8bpp ohne Rahmen
  ScreenControl 100,0,0  ' Bildschirmposition SET_WINDOW_POS ganz links oben
  Color lebcolor,backcolor 
  Cls
  SetMouse (MousePosX, MousePosY, 0, 0 )
  GetMouse (MousePosX, MousePosY, , MouseKeyState, 0 )    'MausStatus am Beginn abfragen
 
  'internes Ziffern-Array in Grundstellung bringen, das ist das aktuelle Arbeitsfeld :
  For i=1 To lh            'log. Hoehe   (Zeilen)
    For j=1 To lb          'log. Breite  (Spalten)V
      numW(i,j) = FALSE
    Next j
  Next i   
    
End Sub


Sub MainLoop
  
  ' ... und hier geht's nun wirklich los !!!
  '      ------------------------------------
  'Intern wird mit dem Ziffern-Array ( dimension lb,lh ) gearbeitet, dort ist 1 lebend und 0 tot. 
  'Die dort gespeicherten Werte werden dann ins Spielegatter transformiert.
  '
  igen   = 1     '  Generation = ein Durchlauf ueber alle logischen Felder des Gatters
  AnfangsBelegung()
  'Uebernahme des Spielegatters ins Vormerkungsfeld :
  For i=1 To lh            'log. Hoehe   (Zeilen)
    For j=1 To lb          'log. Breite  (Spalten)V
      numFolg(i,j) = numW(i,j)    'auf aktuellen Stand bringen ( 0=Tod 1 Geburt inFolgGen) 
    Next j
  Next i 
  '
  'gewollte Endlosschleife (s.LOOP)  :
  Do             
    ' --- Start der aktuellen Generation :  ---
    WindowTitle "CONWAYs Spiel des Lebens / Gen=" & igen
    ' etwas "Kohle" nachlegen :
    If igen Mod 4 = 0 Then
      If ( anfpos<>2 ) Or ( anfpos=2 And igen>7400\iz ) Then
        DropPentomino()       ' 1 Pentomino auf Zufallskoordinaten in numW einstellen
        'wegen DropPentomino neue, nur ergaenzende Uebernahme des Spielegatters ins Vormerkungsfeld :
        For i=1 To lh            'log. Hoehe   (Zeilen)
          For j=1 To lb          'log. Breite  (Spalten)
            If numFolg(i,j) = FALSE Then 'nur tote Felder im Vormerker dürfen überschreiben werden !
               numFolg(i,j) = numW(i,j)    'auf aktuellen Stand bringen ( 0=Tod 1 Geburt inFolgGen) 	
            EndIf
          Next j
        Next i 
      EndIf
    EndIf
    ' Regeln verarbeiten :
    For i=1 To lh
      For j=1 To lb
        CountLivingNeigbors()
        KlassischConway()
        ' ********** hier sind noch andere Regelwelten moeglich !!!!!!!!!!!!!
      Next j
    Next i
    '
    ' --- Ender der aktuellen Generation :  ---
    'internes Ziffern-Array fuer Geburt/Tod verarbeiten, also aktuelles numerisches Array 
    'aktualisieren und Grafik zeichnen :
    fndx = (igen Mod fanz) +1  'math. Remainder
    If fndx > 14 Or fndx<=0 Then
    	fndx = 1
    EndIf
    For i=1 To lh              'log. Hoehe   (Zeilen)
      For j=1 To lb            'log. Breite  (Spalten)
        If numW(i,j) Xor numFolg(i,j) = TRUE Then   'aktuell und Vormerkung unterschiedlich belegt ? 
          numW(i,j) = numFolg(i,j)
          If numW(i,j) = FALSE Then
            ZellTod()
          Else
            ZellGeburt()    
          EndIf   
        EndIf  
      Next j
    Next i
    If ( anfpos<>2 ) Or ( anfpos=2 And igen>7400\iz ) Then
    	If igen Mod 5 = 0 Then
        DropPentomino()       ' 1 Pentomino auf Zufallskoordinaten in numW einstellen
      EndIf  
    EndIf
    ' Verzoegerung :
    Sleep Vzmillsek
    ' wurde Nutzerstop angefordert per "s" ?
    StopKey()
    igen = igen+1
  ' im STOP-Zustand C druecken --> Abbruch  
  Loop until ( InKey = "c"  Or InKey ="C" Or igen > 8000 )  
  
End Sub


'-------------------  es folgen   Level   2   Sub's ----------------------------------------------------------


Sub CountLivingNeigbors
  'Hier werden die lebendigen Nachbarzellen der betrachteten Zelle gezaehlt. ( 3 x 3 ) 
  'Bei OUT OF RANGE eines Nachbarn, also direkt am Rand des Spielegatters, wird die sich
  ' jeweils am genueberliegenden Rand befindliche Zeile/Spalte herangezogen.
  'Damit wird eine Quasi-Endlosigkeit des Spielfeldes vorgetaeuscht...
  LivNbrs = 0
  For k=i-1 To i+1
    For l=j-1 To j+1
       ' Normalfall im Spielfeld ohne Randueberschreitungen (Out Of Range) :
       m=k
       n=l
       ' Out Of Range / Ãœberschreitung links,rechts u. oben,unten = 4 Faelle abhandeln :
       'If RegelTyp <> 2 Then      ' in der Kopierwelt keine Randueberschreitungen !
         If k<1 Then  'Zeile
           m=lh
         EndIf
         If k>lh Then
           m=1
         EndIf
         If l<1 Then  'Spalte
           n=lb
         EndIf
         If l>lb Then
           n=1
         EndIf
       'EndIf       
       ' Zaehlung lebende Nachbarzellen :    
       If numW(m,n) = TRUE Then 
         LivNbrs = LivNbrs + 1
       EndIf 
    Next l
  Next k
  If numW(i,j) = TRUE Then  
    LivNbrs=LivNbrs-1 'die betrachtete Zelle selbst wird NICHT mit gezaehlt, falls sie lebt !
  EndIf 
End Sub


Sub KlassischConway
  'klassische CONWAY-Regeln :
  '-----------------------------------
  ' tot, aber genau 3 lebende Nachbarn :
  If numW(i,j) = FALSE and LivNbrs = 3 then
    numFolg(i,j) = TRUE    ' Vormerken Geburt in Folgegen.
  EndIf
  ' lebend, aber weniger als 2 lebende Nachbarn :
  If numW(i,j) = TRUE and LivNbrs < 2 then  'Tod durch Einsamkeit
    numFolg(i,j) = FALSE   ' Vormerken Absterben in Folgegen.
  EndIf 
  ' lebend, aber mehr als 3 lebende Nachbarn :
  If numW(i,j) = TRUE and LivNbrs > 3 then  'Tod durch Ãœberbevoelkerung 
    numFolg(i,j) = FALSE   ' Vormerken Absterben in Folgegen. 
  EndIf 
  ' lebend mit 2 oder 3 lebenden Nachbarn bleibt am Leben.
End Sub            

Sub AnfangsBelegung
'Anfangsbelegung :
  Randomize(Timer)
  anfpos = Int(Rnd*13) Mod 4
  '
  If anfpos = 0  Then
    For j=5 To lb-5         'log. Breite  (Zeilen)
      numW(Int(lh/2)-3,j) = true 'Balken quer
      numW(Int(lh/2)+3,j) = true    
    Next j
  '  
  ElseIf anfpos = 1 Then
    For i=5 To lh-5      'log. Breite  (Spalten)
      numW(i,Int(lb/2)-9) = true 'Balken hoch
      numW(i,Int(lb/2)+9) = true  
    Next i
  '  
  ElseIf anfpos = 2 Then
  	 balkenh  = Int(lh/8)        
  	 balkenh2 = Int(lh/2)
  	 balkenb  = Int(lb/8) 
  	 balkenb2 = Int(lb/2)        
  	 For i=5 To lh -5	           'log. Breite  (Spalten) 
      numW(i,(balkenb2-balkenb*3)) = true 'Balken hoch
      numW(i,(balkenb2+balkenb*3)) = true 
      numW(i,(balkenb2-balkenb*2)) = true 
      numW(i,(balkenb2+balkenb*2)) = TRUE   
      numW(i,(balkenb2-balkenb  )) = true 
      numW(i,(balkenb2+balkenb  )) = TRUE 
  	 Next i
  	 For j=5 To lb-5             'log. Breite  (Zeilen)
  	   numW((balkenh2+balkenh*3),j) = true 'Balken breit
      numW((balkenh2-balkenh*3),j) = true    
      numW((balkenh2+balkenh*2),j) = true 
      numW((balkenh2-balkenh*2),j) = true    
      numW((balkenh2+balkenh  ),j) = true 
      numW((balkenh2-balkenh  ),j) = true 
    Next j     
  '	 
  ElseIf anfpos = 3 Then
  	 DropPentomino()  ' 1 Pentomino auf Zufallskoordinaten in numW einstellen
  '	 
  Else	 
  EndIf	
End Sub
 

Sub DropPentomino
	' zunächst die Zufallskkordinaten (linkes oberes Pixel) ermitteln, 
	'    dabei Randberührungen vermeiden :
	Randomize(Timer)
	zufx = Int(Rnd*(lh-14)) +3 
	zufy = Int(Rnd*(lb-14)) +3 
	'Print zufx;zufy
	' ein sog. Pentomino auf Zufallskoordinaten ins numerische Arbeitsfeld numW einstellen, 
	' die Belegung umgebender Felder des 3*3-Pentominos ist dabei egal 
	lage = igen Mod 12
	If lage=0 Then                 ' Pentomino
     numW(zufx  ,zufy  )  = FALSE
     numW(zufx+1,zufy  )  = TRUE
	  numW(zufx+2,zufy  )  = TRUE
	  numW(zufx  ,zufy+1)  = TRUE
     numW(zufx+1,zufy+1)  = TRUE
	  numW(zufx+2,zufy+1)  = FALSE
	  numW(zufx  ,zufy+2)  = FALSE
	  numW(zufx+1,zufy+2)  = TRUE
	  numW(zufx+2,zufy+2)  = FALSE
	ElseIf lage=1 then              ' Pentomino
     numW(zufx  ,zufy  )  = TRUE
     numW(zufx+1,zufy  )  = TRUE
	  numW(zufx+2,zufy  )  = FALSE
	  numW(zufx  ,zufy+1)  = FALSE
     numW(zufx+1,zufy+1)  = TRUE
	  numW(zufx+2,zufy+1)  = TRUE
	  numW(zufx  ,zufy+2)  = FALSE
	  numW(zufx+1,zufy+2)  = TRUE
	  numW(zufx+2,zufy+2)  = FALSE
	ElseIf lage=2 Then              ' Pentomino 
     numW(zufx  ,zufy  )  = FALSE
     numW(zufx+1,zufy  )  = TRUE
	  numW(zufx+2,zufy  )  = FALSE
	  numW(zufx  ,zufy+1)  = TRUE
     numW(zufx+1,zufy+1)  = TRUE
	  numW(zufx+2,zufy+1)  = TRUE
	  numW(zufx  ,zufy+2)  = FALSE
	  numW(zufx+1,zufy+2)  = FALSE
	  numW(zufx+2,zufy+2)  = TRUE
	ElseIf lage=3 Then              ' Pentomino
     numW(zufx  ,zufy  )  = FALSE
     numW(zufx+1,zufy  )  = FALSE
	  numW(zufx+2,zufy  )  = TRUE
	  numW(zufx  ,zufy+1)  = TRUE
     numW(zufx+1,zufy+1)  = TRUE
	  numW(zufx+2,zufy+1)  = TRUE
	  numW(zufx  ,zufy+2)  = FALSE
	  numW(zufx+1,zufy+2)  = TRUE
	  numW(zufx+2,zufy+2)  = FALSE
	ElseIf lage=4 Then              ' 2-3-3 rechtwinklig
     numW(zufx  ,zufy  )  = FALSE
     numW(zufx+1,zufy  )  = TRUE
	  numW(zufx+2,zufy  )  = TRUE
	  numW(zufx  ,zufy+1)  = FALSE
     numW(zufx+1,zufy+1)  = FALSE
	  numW(zufx+2,zufy+1)  = TRUE
	  numW(zufx  ,zufy+2)  = TRUE
	  numW(zufx+1,zufy+2)  = TRUE
	  numW(zufx+2,zufy+2)  = TRUE
	ElseIf lage=5 Then              ' 3-3-3-Treppe 3 x 7
     numW(zufx  ,zufy  )  = TRUE
     numW(zufx+1,zufy  )  = TRUE
	  numW(zufx+2,zufy  )  = TRUE
	  numW(zufx+2,zufy+1)  = TRUE
     numW(zufx+3,zufy+1)  = TRUE
	  numW(zufx+4,zufy+1)  = TRUE
	  numW(zufx+4,zufy+2)  = TRUE
	  numW(zufx+5,zufy+2)  = TRUE
	  numW(zufx+6,zufy+2)  = TRUE
	ElseIf lage=6 Then              ' acorn 3 x 7
     numW(zufx  ,zufy  )  = FALSE
     numW(zufx+1,zufy  )  = TRUE
	  numW(zufx+2,zufy  )  = FALSE 
	  numW(zufx+3,zufy  )  = FALSE
	  numW(zufx+4,zufy  )  = FALSE
	  numW(zufx+5,zufy  )  = FALSE
	  numW(zufx+6,zufy  )  = FALSE
	  numW(zufx  ,zufy+1)  = FALSE 	
     numW(zufx+1,zufy+1)  = FALSE
	  numW(zufx+2,zufy+1)  = FALSE
	  numW(zufx+3,zufy+1)  = TRUE
	  numW(zufx+4,zufy+1)  = FALSE 
	  numW(zufx+5,zufy+1)  = FALSE 
	  numW(zufx+6,zufy+1)  = FALSE 
	  numW(zufx  ,zufy+2)  = TRUE
	  numW(zufx+1,zufy+2)  = TRUE
	  numW(zufx+2,zufy+2)  = FALSE 
	  numW(zufx+3,zufy+2)  = FALSE 
	  numW(zufx+4,zufy+2)  = TRUE
	  numW(zufx+5,zufy+2)  = TRUE
	  numW(zufx+6,zufy+2)  = TRUE
	ElseIf lage=7 Then              ' 10er Zeile
	  For m=zufx To zufx+9
       numW(m,zufy)       = TRUE 
	  Next m      
	Else 'gibts nicht 
	EndIf	
End Sub

Sub ZellTod
  'eine bisher lebende Zelle stirbt ab  ( im Gatter )
  ZellPos()
  Line(liox,lioy)-(reux,reuy),totcolor,BF  'gefuelltes Rechteck Farbe tot
End Sub 


Sub ZellGeburt
  'eine bisher leblose Zelle wird belebt ( im Gatter )
  ZellPos()
  Line(liox,lioy)-(reux,reuy),Farbe(fndx),BF  'gefuelltes Rechteck Farbe lebend(fndx)
End Sub 


Sub ZellPos
	'ermittelt die Kordinaten zum Zeichnen des Kästchens
  liox = (j-1)*iz +1 
  lioy = (i-1)*iz +1
  reux = liox + iz -1
  reuy = lioy + iz -1
End Sub


Sub StopKey
  ' Verlassen des Screensavers durch Tastatur-Tastendruck oder Mouse-Bewegung oder Mouse-Tastendruck
  If InKey <>"" Then
  	 'WindowTitle "CONWAYs Sp... /RegTyp=" & RegelTyp & " Gen=" & igen & " Nutzer-Stop ! ( C = Abbruch hier mgl. )"
  	 End
  EndIf
  GetMouse (MousePosXneu, MousePosYneu, , MouseKeyState, 0 )
  If Abs(MousePosX-MousePosXneu) > 30 Or Abs(MousePosY-MousePosYneu) > 30 Then  
    End
  EndIf
  If MouseKeyState Then 
  	 End
  EndIf
End Sub 