#include once "windows.bi"
#Include Once "win/commctrl.bi"
#Include Once "win/commdlg.bi"
#Include Once "win/shellapi.bi"
#Include "Program.bi"

Function WndProc(ByVal hWin As HWND,ByVal uMsg As UINT,ByVal wParam As WPARAM,ByVal lParam As LPARAM) As Integer
	Dim buffer As ZString*256
	Dim x As Integer

	Select Case uMsg
		Case WM_INITDIALOG
			hWnd=hWin
			hIcon=LoadIcon(hInstance,Cast(ZString Ptr,500))
			SendMessage(hWin,WM_SETICON,NULL,Cast(LPARAM,hIcon))
			' Get full path of our program
			GetModuleFileName(NULL,@AppPath,260)
			' Remove program name
			While TRUE
				If InStr(x+1,AppPath,"\") Then
					x=InStr(x+1,AppPath,"\")
				Else
					Exit While
				EndIf
			Wend
			AppPath[x]=NULL
			SetDlgItemText(hWin,IDC_EDT1,@AppPath)
			' Combine two strings
			lstrcat(@AppPath,@Settings)
			SetDlgItemText(hWin,IDC_EDT2,@AppPath)
			' WIN API to write a line of text to an *.ini file
			WritePrivateProfileString(@AppName,@ClassName,@process,@AppPath)
			'
		Case WM_COMMAND
			Select Case HiWord(wParam)
				Case BN_CLICKED,1
					Select Case LoWord(wParam)
						Case IDM_FILE_EXIT
							SendMessage(hWin,WM_CLOSE,0,0)
							'
						Case IDM_HELP_ABOUT
							ShellAbout(hWin,@AppName,@AboutMsg,NULL)
							'
						Case IDC_BTN1
							CreateProcess(@process,0,0,0,0,CREATE_NEW_CONSOLE,0,0,@startinfo,@processinfo)
							'
					End Select
					'
			End Select
			'
		Case WM_SIZE
			'
		Case WM_CLOSE
			DestroyWindow(hWin)
			'
		Case WM_DESTROY
			PostQuitMessage(NULL)
			'
		Case Else
			Return DefWindowProc(hWin,uMsg,wParam,lParam)
			'
	End Select
	Return 0

End Function

Function WinMain(ByVal hInst As HINSTANCE,ByVal hPrevInst As HINSTANCE,ByVal CmdLine As ZString ptr,ByVal CmdShow As Integer) As Integer
	Dim wc As WNDCLASSEX
	Dim msg As MSG

	' Single Instance
	hWnd=FindWindow(@ClassName,NULL)
	If hWnd Then
		ShowWindow(hWnd,SW_RESTORE)
		SetForegroundWindow(hWnd)
		Return 0
	EndIf
	' Setup and register class for dialog
	wc.cbSize=SizeOf(WNDCLASSEX)
	wc.style=CS_HREDRAW or CS_VREDRAW
	wc.lpfnWndProc=@WndProc
	wc.cbClsExtra=0
	wc.cbWndExtra=DLGWINDOWEXTRA
	wc.hInstance=hInst
	wc.hbrBackground=Cast(HBRUSH,COLOR_BTNFACE+1)
	wc.lpszMenuName=Cast(ZString Ptr,IDM_MENU)
	wc.lpszClassName=@ClassName
	wc.hIcon=LoadIcon(NULL,IDI_APPLICATION)
	wc.hIconSm=wc.hIcon
	wc.hCursor=LoadCursor(NULL,IDC_ARROW)
	RegisterClassEx(@wc)
	' Create and show the dialog
	CreateDialogParam(hInstance,Cast(ZString Ptr,IDD_DIALOG),NULL,@WndProc,NULL)
	ShowWindow(hWnd,SW_SHOWNORMAL)
	UpdateWindow(hWnd)
	' Message loop
	Do While GetMessage(@msg,NULL,0,0)
		TranslateMessage(@msg)
		DispatchMessage(@msg)
	Loop
	Return msg.wParam

End Function

' Program start
hInstance=GetModuleHandle(NULL)
CommandLine=GetCommandLine
InitCommonControls
WinMain(hInstance,NULL,CommandLine,SW_SHOWDEFAULT)
ExitProcess(0)

End
