#include once "windows.bi"
#Include Once "win/commctrl.bi"
#Include Once "win/commdlg.bi"
#Include Once "win/shellapi.bi"
#Include Once "win/richedit.bi"
#Include "RichEdit.bi"

Sub DoToolbar(ByVal hTbr As HWND,ByVal hInst As HINSTANCE)
	Dim tbab As TBADDBITMAP
	Dim tbrbtn8 As TBBUTTON=(5,IDM_FILE_EXIT,TBSTATE_ENABLED,TBSTYLE_BUTTON,{0,0},0)
	Dim tbrbtn7 As TBBUTTON=(0,0,TBSTATE_ENABLED,TBSTYLE_SEP,{0,0},0)
	Dim tbrbtn6 As TBBUTTON=(4,IDC_REDO,TBSTATE_ENABLED,TBSTYLE_BUTTON,{0,0},0)
	Dim tbrbtn5 As TBBUTTON=(3,IDC_UNDO,TBSTATE_ENABLED,TBSTYLE_BUTTON,{0,0},0)
	Dim tbrbtn4 As TBBUTTON=(0,0,TBSTATE_ENABLED,TBSTYLE_SEP,{0,0},0)
	Dim tbrbtn3 As TBBUTTON=(2,IDC_PASTE,TBSTATE_ENABLED,TBSTYLE_BUTTON,{0,0},0)
	Dim tbrbtn2 As TBBUTTON=(1,IDC_COPY,TBSTATE_ENABLED,TBSTYLE_BUTTON,{0,0},0)
	Dim tbrbtn1 As TBBUTTON=(0,IDC_CUT,TBSTATE_ENABLED,TBSTYLE_BUTTON,{0,0},0)

	'Set toolbar struct size
	SendMessage(hTbr,TB_BUTTONSTRUCTSIZE,SizeOf(TBBUTTON),0)
	'Set toolbar bitmap
	tbab.hInst=hInst
	tbab.nID=IDB_STD_SMALL_COLOR
	SendMessage(hTbr,TB_ADDBITMAP,15,Cast(LPARAM,@tbab))
	'Set toolbar buttons
	SendMessage(hTbr,TB_ADDBUTTONS,8,Cast(LPARAM,@tbrbtn1))

End Sub

Function WndProc(ByVal hWin As HWND,ByVal uMsg As UINT,ByVal wParam As WPARAM,ByVal lParam As LPARAM) As Integer
	Dim lpTOOLTIPTEXT As TOOLTIPTEXT ptr
	Dim buff As ZString*256
	Dim rect As RECT
	Dim tbht As Integer
	Dim pt As POINT

	Select Case uMsg
		Case WM_INITDIALOG
			hWnd=hWin
			DoToolbar(GetDlgItem(hWin,IDC_TBR1),HINST_COMMCTRL)
			'
		Case WM_COMMAND
			Select Case HiWord(wParam)
				Case BN_CLICKED,1
					Select Case LoWord(wParam)
						Case IDM_FILE_EXIT
							SendMessage(hWin,WM_CLOSE,0,0)
							'
						Case IDM_HELP_ABOUT
							ShellAbout(hWin,@AppName,@AboutMsg,NULL)
							'
						Case IDC_CUT
							SendDlgItemMessage(hWin,IDC_RED1,WM_CUT,0,0)
							'
						Case IDC_COPY
							SendDlgItemMessage(hWin,IDC_RED1,WM_COPY,0,0)
							'
						Case IDC_PASTE
							SendDlgItemMessage(hWin,IDC_RED1,WM_PASTE,0,0)
							'
						Case IDC_UNDO
							SendDlgItemMessage(hWin,IDC_RED1,WM_UNDO,0,0)
							'
						Case IDC_REDO
							SendDlgItemMessage(hWin,IDC_RED1,EM_REDO,0,0)
							'
					End Select
					'
			End Select
			'
		Case WM_NOTIFY
			' ToolBar tooltip
			lpTOOLTIPTEXT=Cast(TOOLTIPTEXT ptr,lParam)
			If lpTOOLTIPTEXT->hdr.code=TTN_NEEDTEXT Then
				LoadString(hInstance,lpTOOLTIPTEXT->hdr.idFrom,@buff,SizeOf(buff))
				lpTOOLTIPTEXT->lpszText=@buff
			EndIf
			'
		Case WM_CONTEXTMENU
			If wParam=GetDlgItem(hWin,IDC_RED1) Then
				pt.x=LoWord(lParam)
				pt.y=HiWord(lParam)
				TrackPopupMenu(GetSubMenu(GetMenu(hWin),0),TPM_LEFTALIGN or TPM_RIGHTBUTTON,pt.x,pt.y,0,hWin,0)
			EndIf
			'
		Case WM_SIZE
			' Autosize the toolbar
			SendDlgItemMessage(hWin,IDC_TBR1,TB_AUTOSIZE,0,0)
			' Get height of toolbar
			GetWindowRect(GetDlgItem(hWin,IDC_TBR1),@rect)
			tbht=rect.bottom-rect.top
			' Get dialog rect
			GetClientRect(hWin,@rect)
			' Size the richedit
			MoveWindow(GetDlgItem(hWin,IDC_RED1),0,tbht,rect.right,rect.bottom-tbht,TRUE)
			'
		Case WM_CLOSE
			DestroyWindow(hWin)
			'
		Case WM_DESTROY
			PostQuitMessage(NULL)
			'
		Case Else
			Return DefWindowProc(hWin,uMsg,wParam,lParam)
			'
	End Select
	Return 0

End Function

Function WinMain(ByVal hInst As HINSTANCE,ByVal hPrevInst As HINSTANCE,ByVal CmdLine As ZString ptr,ByVal CmdShow As Integer) As Integer
	Dim wc As WNDCLASSEX
	Dim msg As MSG

	' Setup and register class for dialog
	wc.cbSize=SizeOf(WNDCLASSEX)
	wc.style=CS_HREDRAW or CS_VREDRAW
	wc.lpfnWndProc=@WndProc
	wc.cbClsExtra=0
	wc.cbWndExtra=DLGWINDOWEXTRA
	wc.hInstance=hInst
	wc.hbrBackground=Cast(HBRUSH,COLOR_BTNFACE+1)
	wc.lpszMenuName=Cast(ZString Ptr,IDM_MENU)
	wc.lpszClassName=@ClassName
	wc.hIcon=LoadIcon(NULL,IDI_APPLICATION)
	wc.hIconSm=wc.hIcon
	wc.hCursor=LoadCursor(NULL,IDC_ARROW)
	RegisterClassEx(@wc)
	' Create and show the dialog
	CreateDialogParam(hInstance,Cast(ZString Ptr,IDD_DIALOG),NULL,@WndProc,NULL)
	ShowWindow(hWnd,SW_SHOWNORMAL)
	UpdateWindow(hWnd)
	' Message loop
	Do While GetMessage(@msg,NULL,0,0)
		TranslateMessage(@msg)
		DispatchMessage(@msg)
	Loop
	Return msg.wParam

End Function

' Program start
hInstance=GetModuleHandle(NULL)
CommandLine=GetCommandLine
InitCommonControls
' Load the RichEdit dll
hRichEdDLL=LoadLibrary("riched20.dll")
WinMain(hInstance,NULL,CommandLine,SW_SHOWDEFAULT)
' Free the dll
FreeLibrary(hRichEdDLL)
ExitProcess(0)

End
